<?php
include 'config.php';
include 'session.php';

try {
    mysqli_begin_transaction($conn);

    $id = $_POST['id'] ?? 0;
    $no_draft = mysqli_real_escape_string($conn, $_POST['no_draft']);
    $tanggal = mysqli_real_escape_string($conn, $_POST['tanggal']);
    $customer_id = mysqli_real_escape_string($conn, $_POST['customer_id']);
    $keterangan = mysqli_real_escape_string($conn, $_POST['keterangan'] ?? '');

    // Hitung total
    $produk_ids = $_POST['produk_id'] ?? [];
    $jumlahs = $_POST['jumlah'] ?? [];
    $hargas = $_POST['harga_jual'] ?? [];
    
    $grand_total = 0;
    for ($i = 0; $i < count($produk_ids); $i++) {
        if (!empty($produk_ids[$i])) {
            $grand_total += (float)$jumlahs[$i] * (float)$hargas[$i];
        }
    }

    if ($id) {
        // Update draft yang sudah ada
        $query = "UPDATE draft_penjualan SET 
                    no_draft = '$no_draft',
                    tanggal = '$tanggal',
                    customer_id = '$customer_id',
                    keterangan = '$keterangan',
                    grand_total = '$grand_total',
                    updated_at = NOW()
                  WHERE id = '$id'";
        
        if (!mysqli_query($conn, $query)) {
            throw new Exception("Gagal update draft: " . mysqli_error($conn));
        }

        // Hapus detail lama
        mysqli_query($conn, "DELETE FROM draft_penjualan_detail WHERE draft_penjualan_id = '$id'");
        
    } else {
        // Cek apakah no_draft sudah ada
        $check_query = "SELECT id FROM draft_penjualan WHERE no_draft = '$no_draft'";
        $check_result = mysqli_query($conn, $check_query);
        
        if (mysqli_num_rows($check_result) > 0) {
            // Generate nomor baru jika duplicate
            $q = mysqli_query($conn, "SELECT no_draft FROM draft_penjualan WHERE no_draft LIKE 'DRAFT-" . date('Ym') . "-%' ORDER BY id DESC LIMIT 1");
            
            if (mysqli_num_rows($q) > 0) {
                $last_row = mysqli_fetch_assoc($q);
                $last_no = $last_row['no_draft'];
                $last_num = (int)substr($last_no, -4);
                $next_num = $last_num + 1;
            } else {
                $next_num = 1;
            }

            $bulan_ini = date('Ym');
            $next = str_pad($next_num, 4, '0', STR_PAD_LEFT);
            $no_draft = "DRAFT-$bulan_ini-$next";
        }
        
        // Insert draft baru
        $query = "INSERT INTO draft_penjualan (
                    no_draft, tanggal, customer_id,
                    keterangan, grand_total, status, created_at
                  ) VALUES (
                    '$no_draft', '$tanggal', '$customer_id',
                    '$keterangan', '$grand_total', 'draft', NOW()
                  )";
        
        if (!mysqli_query($conn, $query)) {
            throw new Exception("Gagal simpan draft: " . mysqli_error($conn));
        }
        
        $id = mysqli_insert_id($conn);
    }

    // Insert detail produk
    $units = $_POST['unit'] ?? [];
    $suppliers = $_POST['supplier'] ?? [];
    $harga_belis = $_POST['harga_beli'] ?? [];

    for ($i = 0; $i < count($produk_ids); $i++) {
        if (!empty($produk_ids[$i]) && !empty($jumlahs[$i])) {
            $produk_id = mysqli_real_escape_string($conn, $produk_ids[$i]);
            $qty = mysqli_real_escape_string($conn, $jumlahs[$i]);
            $satuan = mysqli_real_escape_string($conn, $units[$i] ?? '');
            $harga = mysqli_real_escape_string($conn, $hargas[$i]);
            $supplier = mysqli_real_escape_string($conn, $suppliers[$i] ?? '');
            $harga_beli = mysqli_real_escape_string($conn, $harga_belis[$i] ?? '0');

            $total = (float)$qty * (float)$harga;

            $detail_query = "INSERT INTO draft_penjualan_detail (
                              draft_penjualan_id, produk_id, qty, satuan, harga, 
                              total, supplier, harga_beli
                            ) VALUES (
                              '$id', '$produk_id', '$qty', '$satuan', '$harga',
                              '$total', '$supplier', '$harga_beli'
                            )";

            if (!mysqli_query($conn, $detail_query)) {
                throw new Exception("Gagal simpan detail: " . mysqli_error($conn));
            }
        }
    }

    mysqli_commit($conn);

    // Redirect ke edit draft
    header("Location: draft_penjualan.php?id=$id&success=1");
    exit;

} catch (Exception $e) {
    mysqli_rollback($conn);
    
    // Log error
    error_log("Error draft penjualan: " . $e->getMessage());
    
    // Redirect dengan error
    $redirect = $id ? "draft_penjualan.php?id=$id" : "draft_penjualan.php";
    header("Location: $redirect&error=" . urlencode($e->getMessage()));
    exit;
}
?>