<?php
header('Content-Type: application/json');
include 'config.php';

// Check if kota parameter is provided
if (!isset($_GET['kota']) || empty($_GET['kota'])) {
    echo json_encode([
        'success' => false,
        'message' => 'Kota parameter is required'
    ]);
    exit;
}

$kota = $_GET['kota'];

try {
    // Check if 'aktif' field exists
    $fieldsQuery = "DESCRIBE customer";
    $fieldsResult = $conn->query($fieldsQuery);
    $hasAktifField = false;
    
    if ($fieldsResult) {
        while ($field = $fieldsResult->fetch_assoc()) {
            if ($field['Field'] == 'aktif') {
                $hasAktifField = true;
                break;
            }
        }
    }
    
    // Build query with proper escaping
    $kotaEscaped = mysqli_real_escape_string($conn, $kota);
    
    if ($hasAktifField) {
        $query = "SELECT * FROM customer WHERE kota = '$kotaEscaped' AND aktif = 1 ORDER BY nama ASC";
    } else {
        $query = "SELECT * FROM customer WHERE kota = '$kotaEscaped' ORDER BY nama ASC";
    }
    
    $result = $conn->query($query);
    $customers = [];
    
    if ($result) {
        while ($row = $result->fetch_assoc()) {
            $customers[] = [
                'id' => $row['id'],
                'nama' => $row['nama'],
                'kota' => $row['kota'],
                'jenis' => $row['jenis'] ?? 'Regular',
                'no_hp' => $row['no_hp'] ?? '',
                'notes' => $row['notes'] ?? ''
            ];
        }
        
        echo json_encode([
            'success' => true,
            'customers' => $customers,
            'count' => count($customers),
            'kota' => $kota,
            'query_used' => $query
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Database query failed: ' . $conn->error,
            'query_used' => $query
        ]);
    }
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Error: ' . $e->getMessage()
    ]);
}
?>