<?php
include 'config.php';

if (!isset($_GET['product']) || empty($_GET['product'])) {
    echo json_encode([]);
    exit;
}

$product_name = mysqli_real_escape_string($conn, $_GET['product']);

// Search for exact match first, then fuzzy match
$sql = "SELECT ps.harga, s.nama as supplier_nama, pi.nama as produk_nama, ps.updated_at
        FROM produk_supplier ps
        JOIN supplier s ON ps.supplier_id = s.id
        JOIN produk_interest pi ON ps.produk_id = pi.id
        WHERE pi.nama = '$product_name'
        ORDER BY ps.updated_at DESC, ps.harga ASC";

$result = mysqli_query($conn, $sql);
$recommendations = [];

if (mysqli_num_rows($result) > 0) {
    // Exact match found
    while ($row = mysqli_fetch_assoc($result)) {
        $recommendations[] = [
            'supplier' => $row['supplier_nama'],
            'harga' => floatval($row['harga']),
            'updated' => $row['updated_at']
        ];
    }
} else {
    // Fuzzy search if no exact match
    $sql_fuzzy = "SELECT ps.harga, s.nama as supplier_nama, pi.nama as produk_nama, ps.updated_at
                  FROM produk_supplier ps
                  JOIN supplier s ON ps.supplier_id = s.id
                  JOIN produk_interest pi ON ps.produk_id = pi.id
                  WHERE pi.nama LIKE '%$product_name%' 
                     OR '$product_name' LIKE CONCAT('%', pi.nama, '%')
                  ORDER BY ps.updated_at DESC, ps.harga ASC
                  LIMIT 5";
    
    $result_fuzzy = mysqli_query($conn, $sql_fuzzy);
    
    while ($row = mysqli_fetch_assoc($result_fuzzy)) {
        $recommendations[] = [
            'supplier' => $row['supplier_nama'] . ' (' . $row['produk_nama'] . ')',
            'harga' => floatval($row['harga']),
            'updated' => $row['updated_at']
        ];
    }
}

header('Content-Type: application/json');
echo json_encode($recommendations);
?>