<?php
include 'config.php';
include 'session.php';

$id = $_GET['id'] ?? 0;

if (!$id) {
    header("Location: draft_penjualan_list.php?error=ID draft tidak valid");
    exit;
}

try {
    mysqli_begin_transaction($conn);

    // Cek apakah draft ada dan bisa dihapus
    $check_query = "SELECT id, no_draft, status FROM draft_penjualan WHERE id = '$id'";
    $check_result = mysqli_query($conn, $check_query);

    if (mysqli_num_rows($check_result) == 0) {
        throw new Exception("Draft tidak ditemukan");
    }

    $draft = mysqli_fetch_assoc($check_result);

    // Hapus file nota yang terkait (jika ada)
    $nota_query = "SELECT nota FROM draft_penjualan_detail WHERE draft_penjualan_id = '$id' AND nota != ''";
    $nota_result = mysqli_query($conn, $nota_query);
    
    while ($nota_row = mysqli_fetch_assoc($nota_result)) {
        $file_path = 'nota_uploads/' . $nota_row['nota'];
        if (file_exists($file_path)) {
            unlink($file_path);
        }
    }

    // Hapus detail terlebih dahulu
    $delete_detail = "DELETE FROM draft_penjualan_detail WHERE draft_penjualan_id = '$id'";
    if (!mysqli_query($conn, $delete_detail)) {
        throw new Exception("Gagal menghapus detail draft: " . mysqli_error($conn));
    }

    // Hapus header draft
    $delete_header = "DELETE FROM draft_penjualan WHERE id = '$id'";
    if (!mysqli_query($conn, $delete_header)) {
        throw new Exception("Gagal menghapus draft: " . mysqli_error($conn));
    }

    mysqli_commit($conn);

    header("Location: draft_penjualan_list.php?success=Draft {$draft['no_draft']} berhasil dihapus");
    exit;

} catch (Exception $e) {
    mysqli_rollback($conn);
    
    error_log("Error hapus draft: " . $e->getMessage());
    
    header("Location: draft_penjualan_list.php?error=" . urlencode($e->getMessage()));
    exit;
}
?>