<?php
    include 'session.php';
    include 'navbar.php';  // Pastikan navbar di-load di bagian atas
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Form Input Data</title>

    <!-- Google Fonts: Inter & Open Sans -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600&family=Open+Sans&display=swap" rel="stylesheet" />

    <style>
        /* Mengatur font dan dasar halaman */
        body {
            font-family: 'Inter', sans-serif;
            background-color: #f7f7f7;
            margin: 0;
            padding: 0;
            display: flex;
            flex-direction: column;  /* Agar navbar tetap di atas dan konten lainnya di bawahnya */
        }

        /* Styling untuk navbar, pastikan posisinya tetap di atas */
        nav {
            background-color: #333;
            color: white;
            padding: 10px 20px;
            position: sticky;
            top: 0;  /* Menjaga navbar tetap di atas saat scroll */
            width: 100%;
            z-index: 100; /* Agar navbar tetap berada di atas konten */
        }

        /* Styling container utama */
        .container {
            background-color: #fff;
            padding: 30px;
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1);
            border-radius: 10px;
            width: 100%;
            max-width: 600px;
            text-align: center;
            margin-top: 20px; /* Memberikan ruang di atas form */
        }

        /* Styling judul */
        h2 {
            font-size: 2rem;
            color: #333;
            margin-bottom: 20px;
        }

        /* Styling label input */
        label {
            font-size: 0.9rem;
            color: #555;
            display: block;
            margin-bottom: 5px;
            text-align: left;
        }

        /* Styling textarea */
        textarea {
            width: 100%;
            padding: 12px 15px;
            margin-bottom: 15px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 1rem;
            box-sizing: border-box;
            resize: vertical;
            min-height: 150px;
        }

        /* Button styling */
        input[type="submit"] {
            width: 100%;
            padding: 12px 15px;
            background-color: #4CAF50;
            color: white;
            font-size: 1rem;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }

        /* Hover effect for the button */
        input[type="submit"]:hover {
            background-color: #45a049;
        }
    </style>
</head>
<body>


    <!-- Form Input Data -->
    <div class="container">
        <h2>Form Input Data</h2>
        <form action="insert_data_kapal.php" method="POST">
            <label for="teks">Masukkan Teks:</label><br>
            <textarea id="teks" name="teks" required></textarea><br><br>
            <input type="submit" value="Submit">
        </form>
    </div>
</body>
</html>
