<?php
// Error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Include files
include 'config.php';
include 'session.php';
include 'navbar.php';

// Check database connection
if (!isset($conn) || !$conn) {
    die("Error: Koneksi database tidak tersedia");
}

// Parameters
$periode = isset($_GET['periode']) ? $_GET['periode'] : 'all';
$kategori = isset($_GET['kategori']) ? $_GET['kategori'] : '';
$sort = isset($_GET['sort']) ? $_GET['sort'] : 'penjualan';
$export = isset($_GET['export']) ? $_GET['export'] : '';

// Functions
function formatCurrency($amount) {
    return 'Rp ' . number_format($amount, 0, ',', '.');
}

function formatTanggal($tanggal) {
    return date('d/m/Y', strtotime($tanggal));
}

function getProductCategory($nama_produk) {
    $nama_lower = strtolower($nama_produk);
    
    if (strpos($nama_lower, 'minyak') !== false) {
        return ['kategori' => 'Minyak Goreng', 'class' => 'cat-minyak'];
    } elseif (strpos($nama_lower, 'aqua') !== false || strpos($nama_lower, 'mineral') !== false || strpos($nama_lower, 'teh') !== false) {
        return ['kategori' => 'Minuman', 'class' => 'cat-minuman'];
    } elseif (strpos($nama_lower, 'gula') !== false || strpos($nama_lower, 'tepung') !== false || strpos($nama_lower, 'beras') !== false) {
        return ['kategori' => 'Makanan', 'class' => 'cat-makanan'];
    } elseif (strpos($nama_lower, 'besi') !== false) {
        return ['kategori' => 'Bangunan', 'class' => 'cat-bangunan'];
    } else {
        return ['kategori' => 'Lainnya', 'class' => 'cat-alat'];
    }
}

// Build main query conditions
$where_conditions = ["1=1"];
if ($periode != 'all') {
    $where_conditions[] = "DATE_FORMAT(p.tanggal, '%Y-%m') = '$periode'";
}
$where_clause = "WHERE " . implode(" AND ", $where_conditions);

// Query untuk ranking produk
$ranking_query = "
    SELECT 
        pi.id,
        pi.nama as produk_nama,
        COUNT(DISTINCT p.id) as total_transaksi,
        SUM(pd.qty) as total_qty_terjual,
        SUM(pd.qty * pd.harga) as total_penjualan,
        AVG(pd.harga) as rata_rata_harga_jual,
        AVG(COALESCE(pd.harga_beli, 0)) as rata_rata_harga_beli,
        CASE 
            WHEN AVG(pd.harga) > 0 THEN ((AVG(pd.harga) - AVG(COALESCE(pd.harga_beli, 0))) / AVG(pd.harga) * 100)
            ELSE 0 
        END as margin_persen
    FROM produk_interest pi
    LEFT JOIN penjualan_detail pd ON pi.id = pd.produk_id
    LEFT JOIN penjualan p ON pd.penjualan_id = p.id
    $where_clause AND pd.id IS NOT NULL
    GROUP BY pi.id, pi.nama
    HAVING total_transaksi > 0
";

// Add sorting
switch($sort) {
    case 'qty':
        $ranking_query .= " ORDER BY total_qty_terjual DESC";
        break;
    case 'margin':
        $ranking_query .= " ORDER BY margin_persen DESC";
        break;
    default:
        $ranking_query .= " ORDER BY total_penjualan DESC";
}

$ranking_query .= " LIMIT 20";

$ranking_result = mysqli_query($conn, $ranking_query);
if (!$ranking_result) {
    die("Ranking query error: " . mysqli_error($conn));
}

// Query untuk summary statistics
$summary_query = "
    SELECT 
        COUNT(DISTINCT pi.id) as total_produk_aktif,
        COUNT(DISTINCT p.id) as total_transaksi,
        SUM(pd.qty) as total_qty_terjual,
        SUM(pd.qty * pd.harga) as grand_total_penjualan,
        AVG(CASE 
            WHEN pd.harga > 0 THEN ((pd.harga - COALESCE(pd.harga_beli, 0)) / pd.harga * 100)
            ELSE 0 
        END) as rata_rata_margin
    FROM produk_interest pi
    LEFT JOIN penjualan_detail pd ON pi.id = pd.produk_id
    LEFT JOIN penjualan p ON pd.penjualan_id = p.id
    $where_clause AND pd.id IS NOT NULL
";

$summary_result = mysqli_query($conn, $summary_query);
if (!$summary_result) {
    die("Summary query error: " . mysqli_error($conn));
}
$summary = mysqli_fetch_assoc($summary_result);

// Query untuk produk terlaris
$terlaris_query = "
    SELECT pi.nama as produk_nama
    FROM produk_interest pi
    LEFT JOIN penjualan_detail pd ON pi.id = pd.produk_id
    LEFT JOIN penjualan p ON pd.penjualan_id = p.id
    $where_clause AND pd.id IS NOT NULL
    GROUP BY pi.id, pi.nama
    ORDER BY SUM(pd.qty * pd.harga) DESC
    LIMIT 1
";

$terlaris_result = mysqli_query($conn, $terlaris_query);
$produk_terlaris = mysqli_fetch_assoc($terlaris_result);

// Handle Excel Export
if ($export == 'excel') {
    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment; filename="laporan_produk_' . date('Y-m-d') . '.xls"');
    
    echo "<h3>LAPORAN ANALISIS PRODUK</h3>";
    echo "<table border='1'>";
    echo "<tr>";
    echo "<th>Rank</th>";
    echo "<th>Nama Produk</th>";
    echo "<th>Kategori</th>";
    echo "<th>Qty Terjual</th>";
    echo "<th>Total Penjualan</th>";
    echo "<th>Harga Rata-rata</th>";
    echo "<th>Total Transaksi</th>";
    echo "<th>Margin %</th>";
    echo "</tr>";
    
    mysqli_data_seek($ranking_result, 0);
    $rank = 1;
    while ($row = mysqli_fetch_assoc($ranking_result)) {
        $category = getProductCategory($row['produk_nama']);
        
        echo "<tr>";
        echo "<td>" . $rank . "</td>";
        echo "<td>" . htmlspecialchars($row['produk_nama']) . "</td>";
        echo "<td>" . $category['kategori'] . "</td>";
        echo "<td>" . number_format($row['total_qty_terjual']) . "</td>";
        echo "<td>" . $row['total_penjualan'] . "</td>";
        echo "<td>" . $row['rata_rata_harga_jual'] . "</td>";
        echo "<td>" . $row['total_transaksi'] . "</td>";
        echo "<td>" . number_format($row['margin_persen'], 1) . "%</td>";
        echo "</tr>";
        $rank++;
    }
    echo "</table>";
    exit;
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Laporan Analisis Produk - SBA System</title>
    
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            background-color: #f5f5f5;
            font-size: 13px;
        }

        .container {
            max-width: 100%;
            background: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }

        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 15px;
        }

        .header h1 {
            margin: 0;
            color: #333;
            font-size: 24px;
        }

        .filter-section {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
            border: 1px solid #ddd;
        }

        .filter-section h3 {
            margin: 0 0 15px 0;
            color: #333;
        }

        .form-group {
            display: inline-block;
            margin-right: 20px;
            margin-bottom: 10px;
        }

        .form-group label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }

        .form-group select {
            padding: 8px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 13px;
            min-width: 150px;
        }

        .btn {
            padding: 8px 15px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 13px;
            text-decoration: none;
            display: inline-block;
            margin-right: 10px;
        }

        .btn-primary {
            background: #007bff;
            color: white;
        }

        .btn-success {
            background: #28a745;
            color: white;
        }

        .btn:hover {
            opacity: 0.8;
        }

        .summary-section {
            background: #e8f4fd;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
            border: 1px solid #bee5eb;
        }

        .summary-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
        }

        .summary-item {
            text-align: center;
            background: white;
            padding: 15px;
            border-radius: 8px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }

        .summary-item h4 {
            margin: 0;
            color: #0c5460;
            font-size: 18px;
            font-weight: bold;
        }

        .summary-item p {
            margin: 5px 0 0 0;
            color: #666;
        }

        .table-container {
            overflow-x: auto;
            border: 1px solid #ddd;
            border-radius: 5px;
            margin-bottom: 30px;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
            margin: 0;
            background: white;
        }

        .table th {
            background: #f8f9fa;
            color: #333;
            font-weight: bold;
            padding: 12px 8px;
            text-align: left;
            border-bottom: 2px solid #dee2e6;
            position: sticky;
            top: 0;
            font-size: 12px;
            white-space: nowrap;
        }

        .table td {
            padding: 10px 8px;
            border-bottom: 1px solid #dee2e6;
            vertical-align: top;
            font-size: 12px;
        }

        .table tbody tr:hover {
            background: #f8f9fa;
        }

        .table tbody tr:nth-child(even) {
            background: #fafafa;
        }

        .amount {
            text-align: right;
            font-weight: bold;
        }

        .profit {
            color: #28a745;
        }

        .text-center {
            text-align: center;
        }

        .ranking {
            background: #fff3cd;
            font-weight: bold;
            text-align: center;
            color: #856404;
        }

        .top-product {
            background: #fff3cd;
        }

        .category-badge {
            padding: 3px 8px;
            border-radius: 12px;
            font-size: 11px;
            font-weight: bold;
        }

        .cat-minyak {
            background: #ffc107;
            color: #856404;
        }

        .cat-makanan {
            background: #28a745;
            color: white;
        }

        .cat-minuman {
            background: #17a2b8;
            color: white;
        }

        .cat-bangunan {
            background: #6c757d;
            color: white;
        }

        .cat-alat {
            background: #fd7e14;
            color: white;
        }

        @media print {
            .filter-section, .btn {
                display: none;
            }
            
            body {
                background: white;
                font-size: 11px;
            }
            
            .table th, .table td {
                padding: 5px;
                font-size: 10px;
            }
        }

        @media (max-width: 768px) {
            .form-group {
                display: block;
                margin-right: 0;
                margin-bottom: 15px;
            }
            
            .summary-grid {
                grid-template-columns: 1fr;
            }
            
            .table {
                font-size: 11px;
            }
            
            .table th, .table td {
                padding: 6px 4px;
            }
        }
    </style>
</head>
<body>

<div class="container">
    <div class="header">
        <h1>📦 LAPORAN ANALISIS PRODUK</h1>
        <p>Sistem Manajemen Bisnis SBA</p>
    </div>

    <!-- Filter Section -->
    <div class="filter-section">
        <h3>🔍 Filter Laporan</h3>
        <form method="GET" action="">
            <div class="form-group">
                <label>Periode:</label>
                <select name="periode">
                    <option value="all" <?php echo $periode == 'all' ? 'selected' : ''; ?>>Semua Periode</option>
                    <option value="2025-09" <?php echo $periode == '2025-09' ? 'selected' : ''; ?>>September 2025</option>
                    <option value="2025-08" <?php echo $periode == '2025-08' ? 'selected' : ''; ?>>August 2025</option>
                </select>
            </div>
            
            <div class="form-group">
                <label>Urutkan:</label>
                <select name="sort">
                    <option value="penjualan" <?php echo $sort == 'penjualan' ? 'selected' : ''; ?>>Total Penjualan</option>
                    <option value="qty" <?php echo $sort == 'qty' ? 'selected' : ''; ?>>Quantity Terjual</option>
                    <option value="margin" <?php echo $sort == 'margin' ? 'selected' : ''; ?>>Margin Tertinggi</option>
                </select>
            </div>
            
            <div class="form-group">
                <button type="submit" class="btn btn-primary">📋 Filter</button>
                <a href="?export=excel&<?php echo http_build_query($_GET); ?>" 
                   class="btn btn-success">📊 Export Excel</a>
                <button type="button" onclick="window.print()" class="btn btn-success">🖨️ Print</button>
            </div>
        </form>
    </div>

    <!-- Summary Section -->
    <div class="summary-section">
        <div class="summary-grid">
            <div class="summary-item">
                <h4><?php echo formatCurrency($summary['grand_total_penjualan'] ?? 0); ?></h4>
                <p>Total Penjualan Produk</p>
            </div>
            <div class="summary-item">
                <h4><?php echo number_format($summary['total_produk_aktif'] ?? 0); ?></h4>
                <p>Jenis Produk Aktif</p>
            </div>
            <div class="summary-item">
                <h4><?php echo number_format($summary['total_qty_terjual'] ?? 0); ?></h4>
                <p>Total Unit Terjual</p>
            </div>
            <div class="summary-item">
                <h4><?php echo number_format($summary['rata_rata_margin'] ?? 0, 1); ?>%</h4>
                <p>Margin Rata-rata</p>
            </div>
            <div class="summary-item">
                <h4><?php echo htmlspecialchars($produk_terlaris['produk_nama'] ?? 'N/A'); ?></h4>
                <p>Produk Terlaris</p>
            </div>
        </div>
    </div>

    <!-- Ranking Produk Table -->
    <div class="section-header" style="background: #343a40; color: white; padding: 12px 15px; margin: 30px 0 15px 0; border-radius: 5px; font-weight: bold; font-size: 16px;">
        🏆 RANKING PRODUK BERDASARKAN PENJUALAN
    </div>
    
    <div class="table-container">
        <table class="table">
            <thead>
                <tr>
                    <th>Rank</th>
                    <th>Nama Produk</th>
                    <th>Kategori</th>
                    <th>Qty Terjual</th>
                    <th>Total Penjualan</th>
                    <th>Harga Rata-rata</th>
                    <th>Total Transaksi</th>
                    <th>Margin %</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                if ($ranking_result && mysqli_num_rows($ranking_result) > 0): 
                    $rank = 1;
                    while ($row = mysqli_fetch_assoc($ranking_result)): 
                        $category = getProductCategory($row['produk_nama']);
                        $row_class = $rank <= 3 ? 'top-product' : '';
                        ?>
                        <tr class="<?php echo $row_class; ?>">
                            <td class="ranking"><?php echo $rank; ?></td>
                            <td><strong><?php echo htmlspecialchars($row['produk_nama']); ?></strong></td>
                            <td><span class="category-badge <?php echo $category['class']; ?>"><?php echo $category['kategori']; ?></span></td>
                            <td class="text-center"><?php echo number_format($row['total_qty_terjual']); ?></td>
                            <td class="amount profit"><?php echo formatCurrency($row['total_penjualan']); ?></td>
                            <td class="amount"><?php echo formatCurrency($row['rata_rata_harga_jual']); ?></td>
                            <td class="text-center"><?php echo $row['total_transaksi']; ?></td>
                            <td class="text-center profit"><?php echo number_format($row['margin_persen'], 1); ?>%</td>
                        </tr>
                        <?php 
                        $rank++;
                    endwhile; 
                else: ?>
                    <tr>
                        <td colspan="8" class="text-center">Tidak ada data untuk periode yang dipilih</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <div style="margin-top: 20px; text-align: center; color: #666; font-size: 12px;">
        <p>Laporan dibuat pada: <?php echo date('d F Y H:i:s'); ?></p>
        <p>Total Produk: <?php echo $summary['total_produk_aktif']; ?> | Total Transaksi: <?php echo $summary['total_transaksi']; ?> | Total Unit: <?php echo number_format($summary['total_qty_terjual']); ?></p>
    </div>
</div>

</body>
</html>