<?php
include 'config.php';
include 'session.php';

$meeting_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if (!$meeting_id) {
    header("Location: meeting_list.php");
    exit();
}

$message = '';
$error = '';

// Handle file upload
if ($_POST && isset($_FILES['attachment'])) {
    $upload_dir = 'uploads/meetings/';
    if (!is_dir($upload_dir)) {
        mkdir($upload_dir, 0755, true);
    }
    
    $file = $_FILES['attachment'];
    $agenda_id = !empty($_POST['agenda_id']) ? $_POST['agenda_id'] : null;
    $description = $_POST['description'] ?? '';
    
    if ($file['error'] === UPLOAD_ERR_OK) {
        $file_ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
        $allowed_types = ['jpg', 'jpeg', 'png', 'gif', 'pdf', 'doc', 'docx', 'xls', 'xlsx', 'ppt', 'pptx'];
        
        if (in_array($file_ext, $allowed_types)) {
            $new_filename = $meeting_id . '_' . time() . '_' . $file['name'];
            $file_path = $upload_dir . $new_filename;
            
            if (move_uploaded_file($file['tmp_name'], $file_path)) {
                $stmt = $pdo->prepare("
                    INSERT INTO meeting_attachments 
                    (meeting_id, agenda_id, file_name, file_path, file_type, file_size, mime_type, description, uploaded_by) 
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)
                ");
                
                $file_type = in_array($file_ext, ['jpg', 'jpeg', 'png', 'gif']) ? 'image' : 'document';
                
                $stmt->execute([
                    $meeting_id,
                    $agenda_id,
                    $file['name'],
                    $file_path,
                    $file_type,
                    $file['size'],
                    $file['type'],
                    $description,
                    $_SESSION['user_id']
                ]);
                
                $message = "File berhasil diupload!";
            } else {
                $error = "Gagal mengupload file.";
            }
        } else {
            $error = "Tipe file tidak diizinkan.";
        }
    } else {
        $error = "Error upload: " . $file['error'];
    }
}

// Handle add note
if ($_POST && isset($_POST['add_note'])) {
    $catatan = $_POST['catatan'];
    $agenda_id = !empty($_POST['note_agenda_id']) ? $_POST['note_agenda_id'] : null;
    $jenis_catatan = $_POST['jenis_catatan'] ?? 'general';
    
    if (!empty($catatan)) {
        $stmt = $pdo->prepare("
            INSERT INTO meeting_notes (meeting_id, agenda_id, catatan, jenis_catatan, created_by) 
            VALUES (?, ?, ?, ?, ?)
        ");
        $stmt->execute([$meeting_id, $agenda_id, $catatan, $jenis_catatan, $_SESSION['user_id']]);
        $message = "Catatan berhasil ditambahkan!";
    }
}

// Handle add action item
if ($_POST && isset($_POST['add_action'])) {
    $action_item = $_POST['action_item'];
    $pic_action = $_POST['pic_action'];
    $deadline = !empty($_POST['action_deadline']) ? $_POST['action_deadline'] : null;
    $agenda_id = !empty($_POST['action_agenda_id']) ? $_POST['action_agenda_id'] : null;
    
    if (!empty($action_item) && !empty($pic_action)) {
        $stmt = $pdo->prepare("
            INSERT INTO meeting_action_items (meeting_id, agenda_id, action_item, pic_action, deadline) 
            VALUES (?, ?, ?, ?, ?)
        ");
        $stmt->execute([$meeting_id, $agenda_id, $action_item, $pic_action, $deadline]);
        $message = "Action item berhasil ditambahkan!";
    }
}

// Get meeting data
$meeting_sql = "
    SELECT 
        m.*,
        u_pic.user_name as pic_name,
        u_creator.user_name as creator_name,
        c.nama as customer_nama,
        s.nama as supplier_nama
    FROM meeting m
    LEFT JOIN user u_pic ON m.pic_meeting = u_pic.user_id
    LEFT JOIN user u_creator ON m.created_by = u_creator.user_id
    LEFT JOIN customer c ON m.customer_id = c.id
    LEFT JOIN supplier s ON m.supplier_id = s.id
    WHERE m.id = ?
";

$stmt = $pdo->prepare($meeting_sql);
$stmt->execute([$meeting_id]);
$meeting = $stmt->fetch();

if (!$meeting) {
    header("Location: meeting_list.php");
    exit();
}

// Get agenda
$agenda_sql = "
    SELECT 
        ma.*,
        u.user_name as pic_name
    FROM meeting_agenda ma
    LEFT JOIN user u ON ma.pic_agenda = u.user_id
    WHERE ma.meeting_id = ?
    ORDER BY ma.urutan
";
$stmt = $pdo->prepare($agenda_sql);
$stmt->execute([$meeting_id]);
$agendas = $stmt->fetchAll();

// Get participants
$peserta_sql = "
    SELECT 
        mp.*,
        u.user_name
    FROM meeting_peserta mp
    LEFT JOIN user u ON mp.user_id = u.user_id
    WHERE mp.meeting_id = ?
    ORDER BY u.user_name, mp.nama_external
";
$stmt = $pdo->prepare($peserta_sql);
$stmt->execute([$meeting_id]);
$participants = $stmt->fetchAll();

// Get action items
$action_sql = "
    SELECT 
        mai.*,
        u.user_name as pic_name,
        ma.subject as agenda_subject
    FROM meeting_action_items mai
    LEFT JOIN user u ON mai.pic_action = u.user_id
    LEFT JOIN meeting_agenda ma ON mai.agenda_id = ma.id
    WHERE mai.meeting_id = ?
    ORDER BY mai.created_at DESC
";
$stmt = $pdo->prepare($action_sql);
$stmt->execute([$meeting_id]);
$action_items = $stmt->fetchAll();

// Get attachments
$attachment_sql = "
    SELECT 
        mf.*,
        u.user_name as uploader_name,
        ma.subject as agenda_subject
    FROM meeting_attachments mf
    LEFT JOIN user u ON mf.uploaded_by = u.user_id
    LEFT JOIN meeting_agenda ma ON mf.agenda_id = ma.id
    WHERE mf.meeting_id = ?
    ORDER BY mf.uploaded_at DESC
";
$stmt = $pdo->prepare($attachment_sql);
$stmt->execute([$meeting_id]);
$attachments = $stmt->fetchAll();

// Get notes
$notes_sql = "
    SELECT 
        mn.*,
        u.user_name as creator_name,
        ma.subject as agenda_subject
    FROM meeting_notes mn
    LEFT JOIN user u ON mn.created_by = u.user_id
    LEFT JOIN meeting_agenda ma ON mn.agenda_id = ma.id
    WHERE mn.meeting_id = ?
    ORDER BY mn.created_at DESC
";
$stmt = $pdo->prepare($notes_sql);
$stmt->execute([$meeting_id]);
$notes = $stmt->fetchAll();

// Get users for dropdowns
$users = $pdo->query("SELECT user_id, user_name FROM user WHERE user_aktif = 'Aktif' ORDER BY user_name")->fetchAll();
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Detail Meeting - <?php echo htmlspecialchars($meeting['kode_meeting']); ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/font-awesome.min.css">
    <style>
        .card-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        .agenda-item {
            border-left: 4px solid #0d6efd;
            padding-left: 15px;
            margin-bottom: 15px;
        }
        .attachment-item {
            border: 1px solid #dee2e6;
            border-radius: 8px;
            padding: 10px;
            margin-bottom: 10px;
        }
        .note-item {
            background-color: #f8f9fa;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 10px;
        }
        .action-item {
            border-left: 4px solid #fd7e14;
            padding-left: 15px;
            margin-bottom: 10px;
        }
        .image-preview {
            max-width: 200px;
            max-height: 150px;
            object-fit: cover;
            border-radius: 4px;
        }
    </style>
</head>
<body>

<?php include 'navbar.php'; ?>

<div class="container mt-4">
    <div class="row">
        <div class="col-12">
            
            <?php if ($message): ?>
                <div class="alert alert-success alert-dismissible">
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    <?php echo $message; ?>
                </div>
            <?php endif; ?>
            
            <?php if ($error): ?>
                <div class="alert alert-danger alert-dismissible">
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    <?php echo $error; ?>
                </div>
            <?php endif; ?>

            <!-- Meeting Header -->
            <div class="card shadow mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="mb-0">
                        <i class="fa fa-handshake"></i> <?php echo htmlspecialchars($meeting['kode_meeting']); ?>
                    </h4>
                    <div>
                        <span class="badge bg-<?php 
                            echo $meeting['status'] == 'planned' ? 'primary' : 
                                ($meeting['status'] == 'ongoing' ? 'warning' : 
                                ($meeting['status'] == 'completed' ? 'success' : 'danger')); 
                        ?> me-2">
                            <?php echo ucfirst($meeting['status']); ?>
                        </span>
                        <a href="meeting_edit.php?id=<?php echo $meeting['id']; ?>" class="btn btn-light btn-sm">
                            <i class="fa fa-edit"></i> Edit
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td width="120"><strong>Tanggal:</strong></td>
                                    <td><?php echo date('d M Y', strtotime($meeting['tanggal'])); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Waktu:</strong></td>
                                    <td>
                                        <?php if ($meeting['waktu_mulai']): ?>
                                            <?php echo date('H:i', strtotime($meeting['waktu_mulai'])); ?>
                                            <?php if ($meeting['waktu_selesai']): ?>
                                                - <?php echo date('H:i', strtotime($meeting['waktu_selesai'])); ?>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            Belum ditentukan
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Tempat:</strong></td>
                                    <td><?php echo htmlspecialchars($meeting['tempat']); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Jenis:</strong></td>
                                    <td><span class="badge bg-secondary"><?php echo ucfirst($meeting['jenis_meeting']); ?></span></td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td width="120"><strong>PIC:</strong></td>
                                    <td><?php echo htmlspecialchars($meeting['pic_name'] ?: 'Belum ditentukan'); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Dibuat oleh:</strong></td>
                                    <td><?php echo htmlspecialchars($meeting['creator_name']); ?></td>
                                </tr>
                                <?php if ($meeting['customer_nama']): ?>
                                <tr>
                                    <td><strong>Customer:</strong></td>
                                    <td><?php echo htmlspecialchars($meeting['customer_nama']); ?></td>
                                </tr>
                                <?php endif; ?>
                                <?php if ($meeting['supplier_nama']): ?>
                                <tr>
                                    <td><strong>Supplier:</strong></td>
                                    <td><?php echo htmlspecialchars($meeting['supplier_nama']); ?></td>
                                </tr>
                                <?php endif; ?>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <!-- Left Column -->
                <div class="col-md-8">
                    
                    <!-- Agenda Section -->
                    <div class="card shadow mb-4">
                        <div class="card-header">
                            <h5 class="mb-0"><i class="fa fa-list"></i> Agenda Meeting</h5>
                        </div>
                        <div class="card-body">
                            <?php if (empty($agendas)): ?>
                                <p class="text-muted">Belum ada agenda.</p>
                            <?php else: ?>
                                <?php foreach ($agendas as $agenda): ?>
                                    <div class="agenda-item">
                                        <div class="d-flex justify-content-between align-items-start">
                                            <h6><?php echo $agenda['urutan']; ?>. <?php echo htmlspecialchars($agenda['subject']); ?></h6>
                                            <span class="badge bg-<?php 
                                                echo $agenda['prioritas'] == 'urgent' ? 'danger' : 
                                                    ($agenda['prioritas'] == 'high' ? 'warning' : 
                                                    ($agenda['prioritas'] == 'medium' ? 'primary' : 'secondary')); 
                                            ?> ms-2">
                                                <?php echo ucfirst($agenda['prioritas']); ?>
                                            </span>
                                        </div>
                                        <?php if ($agenda['detail_subject']): ?>
                                            <p class="mb-1"><?php echo nl2br(htmlspecialchars($agenda['detail_subject'])); ?></p>
                                        <?php endif; ?>
                                        <?php if ($agenda['pic_name']): ?>
                                            <small class="text-muted">PIC: <?php echo htmlspecialchars($agenda['pic_name']); ?></small>
                                        <?php endif; ?>
                                    </div>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Participants Section -->
                    <div class="card shadow mb-4">
                        <div class="card-header">
                            <h5 class="mb-0"><i class="fa fa-users"></i> Peserta Meeting</h5>
                        </div>
                        <div class="card-body">
                            <?php if (empty($participants)): ?>
                                <p class="text-muted">Belum ada peserta.</p>
                            <?php else: ?>
                                <div class="row">
                                    <?php 
                                    $internal = array_filter($participants, function($p) { return !empty($p['user_name']); });
                                    $external = array_filter($participants, function($p) { return !empty($p['nama_external']); });
                                    ?>
                                    
                                    <?php if (!empty($internal)): ?>
                                        <div class="col-md-6">
                                            <h6>Peserta Internal:</h6>
                                            <ul class="list-unstyled">
                                                <?php foreach ($internal as $peserta): ?>
                                                    <li><i class="fa fa-user text-primary"></i> <?php echo htmlspecialchars($peserta['user_name']); ?></li>
                                                <?php endforeach; ?>
                                            </ul>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <?php if (!empty($external)): ?>
                                        <div class="col-md-6">
                                            <h6>Peserta External:</h6>
                                            <ul class="list-unstyled">
                                                <?php foreach ($external as $peserta): ?>
                                                    <li>
                                                        <i class="fa fa-user-tie text-secondary"></i> 
                                                        <?php echo htmlspecialchars($peserta['nama_external']); ?>
                                                        <?php if ($peserta['jabatan_external']): ?>
                                                            <br><small class="text-muted ms-3"><?php echo htmlspecialchars($peserta['jabatan_external']); ?></small>
                                                        <?php endif; ?>
                                                        <?php if ($peserta['perusahaan_external']): ?>
                                                            <br><small class="text-muted ms-3"><?php echo htmlspecialchars($peserta['perusahaan_external']); ?></small>
                                                        <?php endif; ?>
                                                    </li>
                                                <?php endforeach; ?>
                                            </ul>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Action Items Section -->
                    <div class="card shadow mb-4">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h5 class="mb-0"><i class="fa fa-tasks"></i> Action Items</h5>
                            <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#addActionModal">
                                <i class="fa fa-plus"></i> Tambah Action
                            </button>
                        </div>
                        <div class="card-body">
                            <?php if (empty($action_items)): ?>
                                <p class="text-muted">Belum ada action items.</p>
                            <?php else: ?>
                                <?php foreach ($action_items as $action): ?>
                                    <div class="action-item">
                                        <div class="d-flex justify-content-between align-items-start">
                                            <div>
                                                <h6><?php echo htmlspecialchars($action['action_item']); ?></h6>
                                                <small class="text-muted">
                                                    PIC: <?php echo htmlspecialchars($action['pic_name']); ?>
                                                    <?php if ($action['deadline']): ?>
                                                        | Deadline: <?php echo date('d M Y', strtotime($action['deadline'])); ?>
                                                    <?php endif; ?>
                                                    <?php if ($action['agenda_subject']): ?>
                                                        | Agenda: <?php echo htmlspecialchars($action['agenda_subject']); ?>
                                                    <?php endif; ?>
                                                </small>
                                            </div>
                                            <span class="badge bg-<?php 
                                                echo $action['status_action'] == 'completed' ? 'success' : 
                                                    ($action['status_action'] == 'in_progress' ? 'warning' : 
                                                    ($action['status_action'] == 'overdue' ? 'danger' : 'secondary')); 
                                            ?>">
                                                <?php echo ucwords(str_replace('_', ' ', $action['status_action'])); ?>
                                            </span>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Right Column -->
                <div class="col-md-4">
                    
                    <!-- Upload File Section -->
                    <div class="card shadow mb-4">
                        <div class="card-header">
                            <h6 class="mb-0"><i class="fa fa-upload"></i> Upload File/Foto</h6>
                        </div>
                        <div class="card-body">
                            <form method="POST" enctype="multipart/form-data">
                                <div class="mb-3">
                                    <label class="form-label">File:</label>
                                    <input type="file" name="attachment" class="form-control" accept=".jpg,.jpeg,.png,.gif,.pdf,.doc,.docx,.xls,.xlsx,.ppt,.pptx" required>
                                    <small class="form-text text-muted">Max 10MB. Format: JPG, PNG, PDF, DOC, XLS, PPT</small>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Terkait Agenda:</label>
                                    <select name="agenda_id" class="form-select">
                                        <option value="">Umum</option>
                                        <?php foreach ($agendas as $agenda): ?>
                                            <option value="<?php echo $agenda['id']; ?>">
                                                <?php echo htmlspecialchars($agenda['subject']); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Deskripsi:</label>
                                    <textarea name="description" class="form-control" rows="2" placeholder="Deskripsi file..."></textarea>
                                </div>
                                <button type="submit" class="btn btn-primary btn-sm w-100">
                                    <i class="fa fa-upload"></i> Upload
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Attachments Section -->
                    <div class="card shadow mb-4">
                        <div class="card-header">
                            <h6 class="mb-0"><i class="fa fa-paperclip"></i> File Terlampir</h6>
                        </div>
                        <div class="card-body">
                            <?php if (empty($attachments)): ?>
                                <p class="text-muted small">Belum ada file.</p>
                            <?php else: ?>
                                <?php foreach ($attachments as $attachment): ?>
                                    <div class="attachment-item">
                                        <?php if ($attachment['file_type'] == 'image'): ?>
                                            <img src="<?php echo htmlspecialchars($attachment['file_path']); ?>" 
                                                 class="image-preview d-block mb-2" 
                                                 alt="<?php echo htmlspecialchars($attachment['file_name']); ?>">
                                        <?php endif; ?>
                                        
                                        <strong class="d-block"><?php echo htmlspecialchars($attachment['file_name']); ?></strong>
                                        
                                        <?php if ($attachment['description']): ?>
                                            <small class="text-muted d-block"><?php echo htmlspecialchars($attachment['description']); ?></small>
                                        <?php endif; ?>
                                        
                                        <?php if ($attachment['agenda_subject']): ?>
                                            <small class="text-info d-block">Agenda: <?php echo htmlspecialchars($attachment['agenda_subject']); ?></small>
                                        <?php endif; ?>
                                        
                                        <small class="text-muted d-block">
                                            <?php echo htmlspecialchars($attachment['uploader_name']); ?> - 
                                            <?php echo date('d M Y H:i', strtotime($attachment['uploaded_at'])); ?>
                                        </small>
                                        
                                        <a href="<?php echo htmlspecialchars($attachment['file_path']); ?>" 
                                           class="btn btn-outline-primary btn-sm mt-2" target="_blank">
                                            <i class="fa fa-download"></i> Download
                                        </a>
                                    </div>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Notes Section -->
                    <div class="card shadow mb-4">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h6 class="mb-0"><i class="fa fa-sticky-note"></i> Catatan</h6>
                            <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#addNoteModal">
                                <i class="fa fa-plus"></i> Tambah
                            </button>
                        </div>
                        <div class="card-body">
                            <?php if (empty($notes)): ?>
                                <p class="text-muted small">Belum ada catatan.</p>
                            <?php else: ?>
                                <?php foreach ($notes as $note): ?>
                                    <div class="note-item">
                                        <div class="d-flex justify-content-between align-items-start mb-1">
                                            <small class="text-muted">
                                                <?php echo htmlspecialchars($note['creator_name']); ?>
                                            </small>
                                            <span class="badge bg-secondary"><?php echo ucfirst($note['jenis_catatan']); ?></span>
                                        </div>
                                        <p class="mb-1"><?php echo nl2br(htmlspecialchars($note['catatan'])); ?></p>
                                        <?php if ($note['agenda_subject']): ?>
                                            <small class="text-info">Agenda: <?php echo htmlspecialchars($note['agenda_subject']); ?></small>
                                        <?php endif; ?>
                                        <small class="text-muted d-block"><?php echo date('d M Y H:i', strtotime($note['created_at'])); ?></small>
                                    </div>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Navigation -->
            <div class="d-flex justify-content-between mt-4">
                <a href="meeting_list.php" class="btn btn-secondary">
                    <i class="fa fa-arrow-left"></i> Kembali ke Daftar
                </a>
                <div>
                    <a href="meeting_edit.php?id=<?php echo $meeting['id']; ?>" class="btn btn-primary">
                        <i class="fa fa-edit"></i> Edit Meeting
                    </a>
                    <a href="meeting_action_items.php?meeting_id=<?php echo $meeting['id']; ?>" class="btn btn-info">
                        <i class="fa fa-tasks"></i> Kelola Actions
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Note Modal -->
<div class="modal fade" id="addNoteModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="POST">
                <div class="modal-header">
                    <h5 class="modal-title">Tambah Catatan</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Jenis Catatan:</label>
                        <select name="jenis_catatan" class="form-select">
                            <option value="general">General</option>
                            <option value="decision">Decision</option>
                            <option value="issue">Issue</option>
                            <option value="information">Information</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Terkait Agenda:</label>
                        <select name="note_agenda_id" class="form-select">
                            <option value="">Umum</option>
                            <?php foreach ($agendas as $agenda): ?>
                                <option value="<?php echo $agenda['id']; ?>">
                                    <?php echo htmlspecialchars($agenda['subject']); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Catatan:</label>
                        <textarea name="catatan" class="form-control" rows="4" required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" name="add_note" class="btn btn-primary">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Add Action Item Modal -->
<div class="modal fade" id="addActionModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="POST">
                <div class="modal-header">
                    <h5 class="modal-title">Tambah Action Item</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Action Item:</label>
                        <textarea name="action_item" class="form-control" rows="3" required placeholder="Deskripsi action yang harus dilakukan..."></textarea>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">PIC:</label>
                        <select name="pic_action" class="form-select" required>
                            <option value="">Pilih PIC...</option>
                            <?php foreach ($users as $user): ?>
                                <option value="<?php echo $user['user_id']; ?>">
                                    <?php echo htmlspecialchars($user['user_name']); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Deadline:</label>
                        <input type="date" name="action_deadline" class="form-control">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Terkait Agenda:</label>
                        <select name="action_agenda_id" class="form-select">
                            <option value="">Umum</option>
                            <?php foreach ($agendas as $agenda): ?>
                                <option value="<?php echo $agenda['id']; ?>">
                                    <?php echo htmlspecialchars($agenda['subject']); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" name="add_action" class="btn btn-primary">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>