<?php
require_once __DIR__ . '/dompdf/autoload.inc.php';
require_once 'config.php';

use Dompdf\Dompdf;
use Dompdf\Options;

// Error handling
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Validasi input
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if (!$id) {
    die('ID penjualan tidak valid');
}

// Cek apakah kolom rekening_id sudah ada di tabel penjualan
$check_column = mysqli_query($conn, "SHOW COLUMNS FROM penjualan LIKE 'rekening_id'");
$has_rekening_id = mysqli_num_rows($check_column) > 0;

// Query data penjualan dan customer - dinamis berdasarkan struktur database
if ($has_rekening_id) {
    $stmt = mysqli_prepare($conn, "
        SELECT p.*, c.nama AS customer_nama, c.kota, c.no_hp, c.kode AS customer_kode,
               r.nama_rekening, r.nama_bank, r.nomor_rekening
        FROM penjualan p 
        JOIN customer c ON p.customer_id = c.id 
        LEFT JOIN rekening r ON p.rekening_id = r.id
        WHERE p.id = ?
    ");
} else {
    $stmt = mysqli_prepare($conn, "
        SELECT p.*, c.nama AS customer_nama, c.kota, c.no_hp, c.kode AS customer_kode
        FROM penjualan p 
        JOIN customer c ON p.customer_id = c.id 
        WHERE p.id = ?
    ");
}

mysqli_stmt_bind_param($stmt, "i", $id);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$data = mysqli_fetch_assoc($result);

if (!$data) {
    die('Data penjualan tidak ditemukan');
}

// Ambil detail produk
$stmt_detail = mysqli_prepare($conn, "
    SELECT d.*, pr.nama AS produk_nama 
    FROM penjualan_detail d 
    JOIN produk_interest pr ON d.produk_id = pr.id 
    WHERE d.penjualan_id = ?
    ORDER BY d.id
");
mysqli_stmt_bind_param($stmt_detail, "i", $id);
mysqli_stmt_execute($stmt_detail);
$detail_result = mysqli_stmt_get_result($stmt_detail);

// Konfigurasi rekening
$rekening_config = [
    'SUMBER BERKAT ANAK' => [
        'nama' => 'SUMBER BERKAT ANAK',
        'no'   => '1372010242304',
        'bank' => 'BANK BRI'
    ],
    'ANGKASA MITRA NIAGA - BRI' => [
        'nama' => 'ANGKASA MITRA NIAGA',
        'no'   => '001001001420309',
        'bank' => 'BANK BRI BLORA'
    ],
    'AHMAD ANDIK NURFIANSYAH' => [
        'nama' => 'AHMAD ANDIK NURFIANSYAH',
        'no'   => '1234567890',
        'bank' => 'BANK BCA'
    ],
    'ANGKASA MITRA NIAGA CV - BCA' => [
        'nama' => 'ANGKASA MITRA NIAGA CV',
        'no'   => '1960350045',
        'bank' => 'BANK BCA BLORA'
    ],
    'HARTONO MULTI REJEKI' => [
        'nama' => 'HARTONO MULTI REJEKI',
        'no'   => '1900332013',
        'bank' => 'BANK BCA'
    ]
];

// Tentukan rekening info berdasarkan data yang ada
$rekening_info = null;

if ($has_rekening_id && !empty($data['nama_rekening'])) {
    $rekening_info = [
        'nama' => $data['nama_rekening'],
        'no'   => $data['nomor_rekening'],
        'bank' => $data['nama_bank']
    ];
} elseif (!empty($data['rekening']) && isset($rekening_config[$data['rekening']])) {
    $rekening_info = $rekening_config[$data['rekening']];
}

// Fungsi untuk convert image ke base64 dengan error handling
function getImageBase64($path, $fallback = '') {
    if (file_exists($path)) {
        $imageData = file_get_contents($path);
        if ($imageData !== false) {
            $extension = strtolower(pathinfo($path, PATHINFO_EXTENSION));
            return 'data:image/' . $extension . ';base64,' . base64_encode($imageData);
        }
    }
    return $fallback;
}

// Load images
$logoPath = __DIR__ . '/logo.png';
$logoSrc = getImageBase64($logoPath);

$stampPath = __DIR__ . '/tandatanganstamp.png';
$stampSrc = getImageBase64($stampPath);

// Company info
$company = [
    'nama' => 'SUMBER BERKAT ANAK',
    'alamat' => '',
    'telepon' => '082381757525',
    'email' => 'isaac@sumberberkatanak.com'
];

// Mulai buat HTML
ob_start();
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Nota Penjualan <?php echo htmlspecialchars($data['no_invoice']); ?></title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body { 
            font-family: Arial, sans-serif; 
            font-size: 12px; /* Diperbesar dari 10px */
            line-height: 1.2; /* Dikurangi dari 1.3 */
            color: #333;
            margin: 0;
            padding: 0;
        }
        
        .container {
            width: 190mm;
            margin: 0 auto;
            padding: 8mm; /* Dikurangi dari 10mm */
        }
        
        /* Header */
        .header {
            width: 100%;
            margin-bottom: 10px; /* Dikurangi dari 15px */
            border-bottom: 2px solid #333;
            padding-bottom: 8px; /* Dikurangi dari 10px */
            overflow: hidden;
        }
        
        .header-left {
            float: left;
            width: 22%;
        }
        
        .header-right {
            float: right;
            width: 76%;
            text-align: right;
            padding-left: 5px;
        }
        
        .logo {
            max-width: 80px;
            height: auto;
        }
        
        .company-info {
            text-align: right;
        }
        
        .company-name {
            font-size: 16px; /* Diperbesar dari 14px */
            font-weight: bold;
            margin-bottom: 3px;
            color: #333;
        }
        
        .company-details {
            font-size: 10px; /* Diperbesar dari 8px */
            color: #666;
            line-height: 1.2;
        }
        
        .clearfix::after {
            content: "";
            display: table;
            clear: both;
        }
        
        /* Title */
        .title {
            text-align: center;
            font-size: 20px; /* Diperbesar dari 18px */
            font-weight: bold;
            margin: 10px 0; /* Dikurangi dari 15px */
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        /* Invoice Info */
        .invoice-info {
            width: 100%;
            margin-bottom: 10px; /* Dikurangi dari 15px */
        }
        
        .invoice-info table {
            width: 100%;
            border-collapse: collapse;
        }
        
        .invoice-info td {
            padding: 2px 5px; /* Dikurangi dari 3px */
            border: none;
            font-size: 12px; /* Diperbesar dari 10px */
        }
        
        .invoice-info .label {
            width: 100px;
            font-weight: bold;
        }
        
        .invoice-info .separator {
            width: 15px;
            text-align: center;
        }
        
        /* Product Table */
        .product-table {
            width: 100%;
            border-collapse: collapse;
            margin: 10px 0; /* Dikurangi dari 15px */
            table-layout: fixed;
        }
        
        .product-table th,
        .product-table td {
            border: 1px solid #333;
            padding: 6px 4px; /* Dikurangi dari 7px 5px */
            text-align: left;
            font-size: 11px; /* Diperbesar dari 10px */
            word-wrap: break-word;
        }
        
        /* Column widths */
        .product-table th:nth-child(1),
        .product-table td:nth-child(1) { width: 6%; }
        
        .product-table th:nth-child(2),
        .product-table td:nth-child(2) { width: 38%; }
        
        .product-table th:nth-child(3),
        .product-table td:nth-child(3) { width: 8%; }
        
        .product-table th:nth-child(4),
        .product-table td:nth-child(4) { width: 8%; }
        
        .product-table th:nth-child(5),
        .product-table td:nth-child(5) { width: 22%; }
        
        .product-table th:nth-child(6),
        .product-table td:nth-child(6) { width: 18%; }
        
        .product-table th {
            background-color: #f5f5f5;
            font-weight: bold;
            text-align: center;
            font-size: 12px; /* Diperbesar dari 11px */
        }
        
        .text-center { text-align: center; }
        .text-right { text-align: right; }
        .text-left { text-align: left; }
        
        .total-row {
            background-color: #f9f9f9;
            font-weight: bold;
            font-size: 12px; /* Diperbesar */
        }
        
        /* Payment Info - DIPERBESAR SIGNIFICANTLY */
        .payment-info {
            margin-top: 12px; /* Dikurangi dari 20px */
            padding: 15px; /* Diperbesar dari 12px */
            background-color: #f0f8ff;
            border: 2px solid #007bff; /* Border lebih tebal dan berwarna */
            border-radius: 8px; /* Radius lebih besar */
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        
        .payment-title {
            font-weight: bold;
            margin-bottom: 8px;
            color: #333;
            font-size: 14px; /* Diperbesar dari 10px */
            text-transform: uppercase;
        }
        
        .bank-name {
            font-size: 16px; /* Diperbesar dari 12px */
            font-weight: bold;
            color: #0066cc;
            margin-bottom: 8px;
            text-transform: uppercase;
        }
        
        .account-info {
            margin-bottom: 4px;
            font-size: 12px; /* Diperbesar dari 9px */
            font-weight: 500;
        }
        
        .account-label {
            font-weight: bold;
            display: inline-block;
            width: 120px; /* Diperbesar dari 100px */
            color: #333;
        }
        
        .account-value {
            font-weight: bold;
            color: #0066cc;
            font-size: 13px; /* Font khusus untuk nilai rekening */
        }
        
        /* Status pembayaran */
        .payment-status {
            margin-top: 10px; /* Dikurangi dari 15px */
            padding: 8px; /* Dikurangi dari 10px */
            border-radius: 3px;
            font-size: 11px; /* Diperbesar dari 10px */
        }
        
        .status-lunas {
            background-color: #d4edda;
            border: 1px solid #c3e6cb;
            color: #155724;
        }
        
        .status-belum-bayar {
            background-color: #fff3cd;
            border: 1px solid #ffeaa7;
            color: #856404;
        }
        
        /* Signature */
        .signature-section {
            margin-top: 20px; /* Dikurangi dari 30px */
            width: 100%;
        }
        
        .signature-table {
            width: 100%;
            border-collapse: collapse;
        }
        
        .signature-cell {
            width: 50%;
            text-align: center;
            vertical-align: top;
            padding: 6px; /* Dikurangi dari 8px */
        }
        
        .signature-img {
            max-height: 50px; /* Dikurangi dari 60px */
            margin-bottom: 6px;
        }
        
        .signature-line {
            border-bottom: 1px solid #333;
            width: 100px; /* Dikurangi dari 120px */
            margin: 10px auto 3px; /* Dikurangi margin */
            height: 25px; /* Dikurangi dari 30px */
        }
        
        .signature-name {
            font-weight: bold;
            margin-top: 2px;
            font-size: 11px; /* Diperbesar dari 10px */
        }
        
        /* Footer */
        .footer {
            margin-top: 15px; /* Dikurangi dari 20px */
            padding-top: 8px; /* Dikurangi dari 10px */
            border-top: 1px solid #ccc;
            font-size: 9px; /* Diperbesar dari 8px */
            color: #666;
            text-align: center;
        }
        
        /* Print specific */
        @media print {
            .container {
                padding: 5mm;
                max-width: none;
                width: 100%;
            }
            
            body {
                margin: 0;
                padding: 0;
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }
            
            @page {
                size: A4;
                margin: 5mm;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header clearfix">
            <?php if ($logoSrc && strtolower($data['jenis']) === 'ppn'): ?>
            <div class="header-left">
                <img src="<?php echo $logoSrc; ?>" class="logo" alt="Logo">
            </div>
            <?php endif; ?>
            
            <div class="header-right">
                <div class="company-info">
                    <div class="company-name"><?php echo htmlspecialchars($company['nama']); ?></div>
                    <div class="company-details">
                        <?php echo htmlspecialchars($company['alamat']); ?><br>
                        Telp: <?php echo htmlspecialchars($company['telepon']); ?><br>
                        Email: <?php echo htmlspecialchars($company['email']); ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Title -->
        <div class="title">NOTA PENJUALAN</div>

        <!-- Invoice Info -->
        <div class="invoice-info">
            <table>
                <tr>
                    <td class="label">No. Invoice</td>
                    <td class="separator">:</td>
                    <td style="width: 40%;"><?php echo htmlspecialchars($data['no_invoice']); ?></td>
                    <td class="label" style="padding-left: 20px;">Customer</td>
                    <td class="separator">:</td>
                    <td><?php echo htmlspecialchars($data['customer_nama']); ?></td>
                </tr>
                <tr>
                    <td class="label">Tanggal</td>
                    <td class="separator">:</td>
                    <td><?php echo date('d F Y', strtotime($data['tanggal'])); ?></td>
                    <?php if (!empty($data['kota'])): ?>
                    <td class="label" style="padding-left: 20px;">Kota</td>
                    <td class="separator">:</td>
                    <td><?php echo htmlspecialchars($data['kota']); ?></td>
                    <?php else: ?>
                    <td colspan="3"></td>
                    <?php endif; ?>
                </tr>
                <!-- Bagian No HP dan Jenis Transaksi telah dihapus -->
            </table>
        </div>

        <!-- Product Table -->
        <table class="product-table">
            <thead>
                <tr>
                    <th>No</th>
                    <th>Nama Produk</th>
                    <th>Qty</th>
                    <th>Unit</th>
                    <th>Harga Satuan</th>
                    <th>Total</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $no = 1;
                $grand_total = 0;
                
                while ($d = mysqli_fetch_assoc($detail_result)) {
                    $total = $d['qty'] * $d['harga'];
                    $grand_total += $total;
                    ?>
                    <tr>
                        <td class="text-center"><?php echo $no; ?></td>
                        <td><?php echo htmlspecialchars($d['produk_nama']); ?></td>
                        <td class="text-center"><?php echo number_format($d['qty']); ?></td>
                        <td class="text-center"><?php echo htmlspecialchars($d['satuan']); ?></td>
                        <td class="text-right">Rp <?php echo number_format($d['harga'], 0, ',', '.'); ?></td>
                        <td class="text-right">Rp <?php echo number_format($total, 0, ',', '.'); ?></td>
                    </tr>
                    <?php
                    $no++;
                }
                ?>
                
                <!-- Total Row -->
                <tr class="total-row">
                    <td colspan="5" class="text-right" style="font-weight: bold;">GRAND TOTAL</td>
                    <td class="text-right" style="font-weight: bold;">Rp <?php echo number_format($grand_total, 0, ',', '.'); ?></td>
                </tr>
            </tbody>
        </table>

        <!-- Status Pembayaran -->
        <?php if (!empty($data['status_bayar'])): ?>
        <div class="payment-status <?php echo $data['status_bayar'] == 'lunas' ? 'status-lunas' : 'status-belum-bayar'; ?>">
            <strong>Status Pembayaran: <?php echo strtoupper(str_replace('_', ' ', $data['status_bayar'])); ?></strong>
            <?php if ($data['status_bayar'] == 'lunas' && !empty($data['tanggal_bayar'])): ?>
                <br>Tanggal Bayar: <?php echo date('d F Y', strtotime($data['tanggal_bayar'])); ?>
                <?php if (!empty($data['keterangan_bayar'])): ?>
                    <br>Keterangan: <?php echo htmlspecialchars($data['keterangan_bayar']); ?>
                <?php endif; ?>
            <?php endif; ?>
        </div>
        <?php endif; ?>

        <!-- Payment Info - REDESIGNED LEBIH MENONJOL -->
        <?php if ($rekening_info): ?>
        <div class="payment-info">
            <div class="payment-title">INFORMASI PEMBAYARAN</div>
            <div class="bank-name"><?php echo htmlspecialchars($rekening_info['bank']); ?></div>
            <div class="account-info">
                <span class="account-label">Nama Rekening:</span> 
                <span class="account-value"><?php echo htmlspecialchars($rekening_info['nama']); ?></span>
            </div>
            <div class="account-info">
                <span class="account-label">No. Rekening:</span> 
                <span class="account-value"><?php echo htmlspecialchars($rekening_info['no']); ?></span>
            </div>
        </div>
        <?php endif; ?>

        <!-- Signature Section -->
        <div class="signature-section">
            <table class="signature-table">
                <tr>
                    <td class="signature-cell">
                        <?php if ($stampSrc): ?>
                            <img src="<?php echo $stampSrc; ?>" class="signature-img" alt="Tanda Tangan">
                        <?php else: ?>
                            <div class="signature-line"></div>
                        <?php endif; ?>
                        <div class="signature-name">Isaac Susanto</div>
                        <div>Penjual</div>
                    </td>
                    <td class="signature-cell">
                        <div class="signature-line"></div>
                        <div class="signature-name">( ............................ )</div>
                        <div>Pembeli</div>
                    </td>
                </tr>
            </table>
        </div>

        <!-- Footer -->
        <div class="footer">
            <div>Terima kasih atas kepercayaan Anda. Barang wajib asuransi.</div>
            <div>Dokumen ini dicetak pada: <?php echo date('d F Y H:i:s'); ?></div>
        </div>
    </div>
</body>
</html>

<?php
$html = ob_get_clean();

// Konfigurasi Dompdf
$options = new Options();
$options->set('defaultFont', 'Arial');
$options->set('isRemoteEnabled', true);
$options->set('isPhpEnabled', true);

// Inisialisasi Dompdf
$dompdf = new Dompdf($options);
$dompdf->loadHtml($html);

// Set ukuran dan orientasi
$dompdf->setPaper('A4', 'portrait');

// Render ke PDF
$dompdf->render();

// Generate filename
$filename = "Nota_" . $data['no_invoice'] . "_" . date('Y-m-d') . ".pdf";

// Output ke browser
$dompdf->stream($filename, ["Attachment" => false]);
exit;
?>